/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWWorkBasketsSelectionTableModel;
import filenet.vw.toolkit.admin.property.queue.VWNewWorkBasketWizard;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWCheckBoxTableCellEditor;
import filenet.vw.toolkit.utils.table.VWCheckBoxTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWInfoLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWRoleSelectBasketsDialog
extends VWModalDialog
implements ActionListener {
    protected static final int STATUS_NONE = 0;
    protected static final int STATUS_OK = 1;
    protected static final int STATUS_CANCEL = 2;
    protected VWSessionInfo m_sessionInfo = null;
    protected VWDataDictionary m_dataDictionary = null;
    protected HashSet m_modifiedQueueNames = null;
    protected VWRoleDefinition m_roleDef = null;
    protected VWTable m_workBasketsTable = null;
    protected VWWorkBasketsSelectionTableModel m_workBasketsTableModel = null;
    protected JButton m_addWorkbasketButton = null;
    protected JButton m_OKButton = new JButton(VWResource.OK);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    protected boolean m_bIsModified = false;
    protected int m_status = 0;

    public VWRoleSelectBasketsDialog(VWDataDictionary dataDict, VWRoleDefinition roleDef) {
        super(dataDict.getSessionInfo().getParentFrame());
        this.m_sessionInfo = dataDict.getSessionInfo();
        this.m_dataDictionary = dataDict;
        this.m_roleDef = roleDef;
        this.setTitle(VWResource.Add);
        Dimension dim = VWStringUtils.stringToDimension("555,275");
        if (dim == null) {
            dim = new Dimension(555, 275);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel panel = this.createWorkBasketsPanel();
        mainPanel.add((Component)panel, "Center");
        panel.getAccessibleContext().setAccessibleParent(mainPanel);
        panel = this.createButtonPanel();
        mainPanel.add((Component)panel, "Last");
        panel.getAccessibleContext().setAccessibleParent(mainPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        mainPanel.getAccessibleContext().setAccessibleParent(this);
        this.addKeyListener(VWKeyAdapter.s_keyAdapter);
    }

    public void releaseResources() {
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_addWorkbasketButton != null) {
            this.m_addWorkbasketButton.removeActionListener(this);
            this.m_addWorkbasketButton.removeAll();
            this.m_addWorkbasketButton = null;
        }
        if (this.m_workBasketsTable != null) {
            this.m_workBasketsTable.removeAll();
            this.m_workBasketsTable = null;
        }
        if (this.m_workBasketsTableModel != null) {
            this.m_workBasketsTableModel.releaseResources();
            this.m_workBasketsTableModel = null;
        }
        this.m_sessionInfo = null;
        this.m_roleDef = null;
        this.removeAll();
    }

    private JPanel createWorkBasketsPanel() {
        try {
            JPanel workBasketPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 5, 0);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            VWInfoLabel inBasketsLabel = new VWInfoLabel(VWResource.SelectInbasketsForRole, VWResource.SelectInbasketsForRoleDescription);
            VWAccessibilityHelper.setAccessibility(inBasketsLabel, this, VWResource.SelectInbasketsForRole, VWResource.SelectInbasketsForRole);
            workBasketPanel.add((Component)inBasketsLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            ImageIcon icon = VWImageLoader.createImageIconNoMessage("createWorkBasket24.gif");
            this.m_addWorkbasketButton = new JButton(icon);
            this.m_addWorkbasketButton.setToolTipText(VWResource.CreateInbasketDescription);
            this.m_addWorkbasketButton.addActionListener(this);
            this.m_addWorkbasketButton.setMargin(new Insets(0, 5, 0, 5));
            VWAccessibilityHelper.setAccessibility(this.m_addWorkbasketButton, this, VWResource.CreateInbasket, VWResource.CreateInbasket);
            workBasketPanel.add((Component)this.m_addWorkbasketButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.gridwidth = 0;
            this.m_workBasketsTableModel = new VWWorkBasketsSelectionTableModel(this.m_dataDictionary);
            this.m_workBasketsTableModel.setRoleDefinition(this.m_roleDef);
            this.m_workBasketsTable = new VWTable(this.m_workBasketsTableModel);
            this.m_workBasketsTable.setRowSelectionAllowed(true);
            this.m_workBasketsTable.setShowGrid(false);
            this.m_workBasketsTable.setRowHeight(26);
            this.m_workBasketsTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_workBasketsTable, this, VWResource.InbasketsTable, VWResource.InbasketsTable);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Inbaskets), this.m_workBasketsTable);
            TableColumn tcElement = this.m_workBasketsTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                VWCheckBoxTableCellRenderer renderer = new VWCheckBoxTableCellRenderer();
                tcElement.setCellRenderer(renderer);
                tcElement.setCellEditor(new VWCheckBoxTableCellEditor());
            }
            workBasketPanel.add((Component)new JScrollPane(this.m_workBasketsTable), gbCons);
            return workBasketPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_OKButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_OKButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            mainPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, mainPanel, this.m_OKButton.getText(), this.m_OKButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, mainPanel, this.m_cancelButton.getText(), this.m_cancelButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, mainPanel, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj.equals(this.m_cancelButton)) {
            this.m_status = 2;
            this.setVisible(false);
        } else if (obj.equals(this.m_OKButton)) {
            this.m_status = 1;
            this.setVisible(false);
        } else if (obj.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc098.htm");
        } else if (obj.equals(this.m_addWorkbasketButton)) {
            this.addNewWorkBasket();
        }
    }

    protected void addNewWorkBasket() {
        try {
            VWNewWorkBasketWizard wizardDlg = new VWNewWorkBasketWizard(this.m_sessionInfo, this.m_dataDictionary);
            wizardDlg.show();
            if (wizardDlg.getExitStatus() == 0) {
                VWWorkBasketDefinition workBasketDef = wizardDlg.getWorkBasketDefinition();
                VWQueueDefinition queueDef = this.m_dataDictionary.getQueueDefinition(workBasketDef.getQueueName());
                workBasketDef = queueDef.createCopyOfWorkBasketDefinition(workBasketDef.getName(), workBasketDef);
                this.m_workBasketsTableModel.addNewWorkBasket(workBasketDef);
                if (this.m_modifiedQueueNames == null) {
                    this.m_modifiedQueueNames = new HashSet();
                }
                this.m_modifiedQueueNames.add(workBasketDef.getQueueName());
                int nRow = this.m_workBasketsTable.getRowCount() - 1;
                this.m_workBasketsTable.setRowSelectionInterval(nRow, nRow);
                this.m_workBasketsTable.ensureRowIsVisible(nRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWWorkBasketDefinition[] getSelectedItems() {
        return this.m_workBasketsTableModel.getSelectedItems();
    }

    protected void refreshWorkBasketTable() {
        if (this.m_workBasketsTableModel.isModified()) {
            this.m_bIsModified = true;
        }
        this.m_workBasketsTableModel.reinitialize(this.m_dataDictionary);
    }

    public boolean isModified() {
        if (this.m_workBasketsTableModel != null && this.m_workBasketsTableModel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    public String[] getModifiedQueueNames() {
        if (this.m_modifiedQueueNames != null && !this.m_modifiedQueueNames.isEmpty()) {
            return this.m_modifiedQueueNames.toArray(new String[0]);
        }
        return null;
    }

    public int getExitStatus() {
        return this.m_status;
    }
}

